package gov.va.med.mhv.sm.admin.service.impl;

import java.util.List;


import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import javax.ws.rs.QueryParam;
import gov.va.med.mhv.sm.admin.jpa.model.Facility;
import gov.va.med.mhv.sm.admin.dto.FacilityDTO;
import gov.va.med.mhv.sm.admin.data.enums.SMErrorEnum;
import gov.va.med.mhv.sm.admin.jpa.repository.FacilityRepository;
import gov.va.med.mhv.sm.admin.converter.SMFacilityConverter;
import gov.va.med.mhv.sm.admin.exception.SMApiException;
import gov.va.med.mhv.sm.admin.service.util.ResponseCodeUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.responses.ApiResponse;


@Path("/facilities")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
@Service("facilityService")
@Component
public class FacilityService { 

    @Autowired
    private FacilityRepository facilityRepository;
    
	
	private static final Log log = LogFactory.getLog(FacilityService.class);

	private List<FacilityDTO> getVisns() throws SMApiException  {
		
		List<Facility> visnList = null;
		
		List<FacilityDTO> visnDTOList = null;
		try 
		{
			visnList = facilityRepository.getVisns();
			
			if(visnList != null && visnList.size()>0 ) {
				visnDTOList = SMFacilityConverter.convertList(visnList);
			}else {
				throw new SMApiException(SMErrorEnum.TRIAGE_GROUP_NOT_FOUND.getErrorMessage(), ResponseCodeUtil.STATUS_NOT_FOUND);
			}
		
		} catch (Exception e) {
			log.error(e);
			throw new SMApiException("UnExpected Error Occurred", ResponseCodeUtil.STATUS_INTERNAL_SERVER_ERROR,e);
		}

		return visnDTOList;
	}
	
	@GET
	@Operation(summary = "Get Facilityies By Visn")
	@ApiResponses(value = {
	        @ApiResponse(responseCode = "200", 
	        			content = @Content(mediaType = "application/json", 
	        			array = @ArraySchema(schema = @Schema(implementation = Facility.class)))),
			@ApiResponse(responseCode = "404", description = "Facilities are not found",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class))),
			@ApiResponse(responseCode = "500", description = "UnExpected Error Occurred",content = @Content(mediaType = "application/json", schema = @Schema(implementation = SMApiException.class)))
	})
	public List<FacilityDTO> getFacilitiesByVisn(@QueryParam("visnId") Long visnId)  throws SMApiException  {
		
		List<Facility> facilityList = null;
		List<FacilityDTO> dtoList = null;
		try 
		{
			if(visnId != null) {
				facilityList = facilityRepository.getFacilityByVisn(visnId);
			}else {
				dtoList = getVisns();
			}
			
			
			if(facilityList != null && facilityList.size()>0 ) {
				dtoList = SMFacilityConverter.convertList(facilityList);
			}
			
			if(dtoList == null || dtoList.size()==0) {
				throw new SMApiException(SMErrorEnum.TRIAGE_GROUP_NOT_FOUND.getErrorMessage(), ResponseCodeUtil.STATUS_NOT_FOUND);
			}
			
		
		} catch (Exception e) {
			log.error(e);
			throw new SMApiException(SMErrorEnum.UNKNOWN_EXCEPTION.getErrorMessage(), ResponseCodeUtil.STATUS_INTERNAL_SERVER_ERROR,e);
		}

		return dtoList;
	}
	
	
}
